<?php

/*
+---------------------------------------------------------------------------
|
|   > TASK SCRIPT: Rss
|   > Script written by x00179
|   > Date started: 30th March 2004
|	> Version: 1.10
|
+--------------------------------------------------------------------------
*/

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}


class task_item
{
	var $class     = "";
	var $root_path = "";
	var $task      = "";
	// RSS Needed
	var $state = 0;    			// To determine which element tag is being worked
	var $level = 0; 	   		// Simple XML level control
	var $channel = array();		// Array of channel cdata
	var $image = array();		// Array of image cdata	
	var $item = array();		// Array of item cdata
	var $channelclosed = false;	// To indicate state if channel closes before image tags.
	var $arss = array();		// Array of Topics in the Database
	var $fid = 0;				// Forum ID
	var $counter = 0;
	var $failed = 0;
	var $lastpostfix = 0;

	/*-------------------------------------------------------------------------*/
	// Our 'auto_run' function
	// ADD CODE HERE
	/*-------------------------------------------------------------------------*/
	
	function run_task()
	{
		global $DB, $ibforums, $std;
		
		//---------------------------------------
		// Main code here
		//---------------------------------------
		
		//$DB->simple_construct( array(	'select' => '','from' => 'forums','where' => 'redirect_loc = "&lt;xml&gt;"'
		$duel= $DB->query("SELECT f.id,f.topics,f.redirect_url,t.title	FROM ibf_forums AS f
					LEFT JOIN ibf_topics AS t ON (t.forum_id=f.id)
					WHERE f.redirect_loc = '&lt;xml&gt;' ORDER BY f.id ASC");
		$fx=array();$fx['fid']=0;
		while($row = $DB->fetch_row($duel))
		{
			if($fx['fid']!=$row['id']) 
			{
				$this->lastpostfix = 1;
				//This not the first time so update the last forum first 
			 	if($fx['fid']) $this->update_rssforum($fx);
				$fx['fid'] = $row['id'];
				$fx['topics'] = $row['topics'];
				$fx['redirect_url'] = $row['redirect_url'];
				$fx['rss'] = array();
				$fx['rss'][] = $row['title'];
			}
			else  $fx['rss'][] = $row['title'];
		}
		// Update the forum if there are RSS Forums
		if($fx['fid']) $this->update_rssforum($fx);
		//---------------------------------------
		// Log to log table - modify but dont delete
		//---------------------------------------
		
		$this->class->append_task_log( $this->task, $this->counter.' RSS News feeds added '.$this->failed.' RSS have failed');
	}
	
	/*-------------------------------------------------------------------------*/
	// register_class
	// LEAVE ALONE
	/*-------------------------------------------------------------------------*/
	
	function register_class(&$class)
	{
		$this->class = $class;
		
		$this->root_path = $this->class->root_path;
	}
	
	/*-------------------------------------------------------------------------*/
	// pass_task
	// LEAVE ALONE
	/*-------------------------------------------------------------------------*/
	
	function pass_task( $this_task )
	{
		$this->task = $this_task;
	}
	
	// Update the RSS feed Forum
	function update_rssforum ($fx)
	{
		$this->arss = $fx['rss'];
		$this->fid = intval($fx['fid']);
		$this->tcnt = intval($fx['topics']);
		
		// it can be used to process an RSS/XML feed from any web site, including local.
		$data = @file($fx['redirect_url']); //die ("Could not open a feed called: " . $fx['redirect_url']);
		if(empty($data)) {$this->failed++;return;}
		$contents = implode('',$data);  // Put data into an array

		// Set the version state
		if (strpos($this->contents,'version="0.9'))  $version = 9;
		elseif (strpos($this->contents,"rdf:")) $version = 1;
		elseif (strpos($this->contents,'version="2.0"')) $version = 2;		
		else $version = 9;
		
		// Create the parser and set handlers.
		$psr = xml_parser_create();
		
		xml_set_object($psr, $this);
		xml_parser_set_option($psr,XML_OPTION_CASE_FOLDING,1);
		
		// Set the parser element handlers based upon the version.
		switch ($version)
		{
		  case 9:
		  case 2;
			xml_set_element_handler($psr, '_handle_open_element', '_handle_close_element');
			break;
		  case 1:
			xml_set_element_handler($psr, '_rdf_handle_open_element', '_handle_close_element');
			break;
		}
		// Set the handler for the cdata
		xml_set_character_data_handler($psr, "_handle_character_data");
		
		// Parse it.
		if (!xml_parse ($psr, $contents))
		{
		  // This returns an error message if the RSS/XML cannot be parsed. 
		  // Too bad.
		  // This indicates a bad or malformed feed!
		  $ln =  xml_get_current_line_number($psr);
		  $msg =  xml_error_string(xml_get_error_code($psr));
		  return;
		}
		
		// Free up the parser and clear memory
		xml_parser_free($psr);
		$contents = "";
	}
	
	//**************************************************************
	// HANDLER FUNCTIONS
	//**************************************************************
	function _handle_open_element (&$p, &$element, &$attributes)
	{
		// parser for rss version 0.9x and 2.0
		// Set the state of the class for the benefit of the cdata handler.
		$element = strtolower($element);
		switch($element) 
		{
		  case 'rss':
			// data at this level may not be needed
			$this->level = 0;
			$this->state = 0;
			break;
		  case 'channel':
			// The channel may have a title and a link and a description
			// This data will not be part of the list, but will precede it.
			$this->level = 1;
			$this->state = 1;
			break;
		  case 'item':
			// We have an item to process
			$this->level = 3;
			$this->state = 3;
			break;
		  // some tags that will appear under 'channel'
		  // for now, ignore these tags. 
		  case 'pubdate':
		  case 'managingeditor':
		  case 'webmaster':
		  case 'width':
		  case 'height':
		  case 'language':
			$this->state = 99;
			break;
		  case 'image':
			// This assumes the image is a container element, as this is most common
			$this->level = 2;
			break;
		  case 'title':
			$this->state = 4;
			break;
		  case 'link':
			$this->state = 5;
			break;
		  case 'description':
			$this->state = 6;
			break;
		  case 'url':
			$this->state = 7;
			break;
		  default:
			// ignore any undefined tags
			$this->state = 99;
			break;
		}
	}
	
	function _rdf_handle_open_element(&$p, &$element, &$attributes)
	{
		$element = strtolower($element);
		switch($element)
		{
		  case "rdf:rdf":
			// The parser takes care of the Namespace, so we can ignore this.
			$this->level = 0;
			$this->state = 0;
			break;
		  case "channel":
			// Same as above.
			$this->level = 1;
			$this->state = 1;
			break;
		  case "image":
			// Assumes <image> is a container element. This is most common.
			$this->level = 2;
			break;
		  case "items":
			// channel parameters stop and items begin. We can ignore this.
			$this->state = 99;
			break;
		  case "item":
			// We have an item to process.
			$this->level = 3;
			$this->state = 3;
			break;	
		  case "title":
			$this->state = 4;
			break;
		  case "link":
			$this->state = 5;
			break;
		  case "description":
			$this->state = 6;
			break;
		  case "url":
			$this->state = 7;
			break;
		  case "rdf:seq":
		  case "rdf:li":
		  default:
			// ignore tags
			$this->state = 99;
			break;
		}
	}
	
	function _handle_character_data(&$p, &$cdata)
	{
		// Ignore $cdata filled with blanks or nothing
		$s = trim($cdata);
		if (strlen($s)) {
		  // We really only need these things now: Title, Links and, if desired, Description and Image URL
		  switch ($this->state) 
		  {
			case 4:  // title
			  switch ($this->level) 
			  {
			  // This are the only levels that are important here.
				case 1:  // Channel
				  $this->channel["title"] .= $cdata;
				  break;
				case 2; // Image
				  $this->image["title"] .= $cdata;
				  break;
				case 3:  // Item
				  $this->item["title"] .= $cdata;
				  break;
			  }
			  break;
			case 5:  // link
			  switch ($this->level) 
			  {
				case 1: // Channel
				// Make the link for the channel and change to item level. We're done here.
				  $this->channel["link"] .= $cdata;
				  break;
				case 2: // Image
				  $this->image["link"] .= $cdata;
				  break;
				case 3: // Item
				// Make the link for the item. Reset the flag and initialize the unordered list.
				// Add the link for the item
				  $this->item["link"] .= $cdata;
				  break;
			  }
			  break;
			case 6:  // description
			  // If the description is desired, add it now.
				switch ($this->level) 
				{
				  case 1: // Channel
					$this->channel["desc"] .= $cdata;
					break;
				  case 3: // Item
					$this->item["desc"] .= $cdata;
					break;
				}
			  break;
			case 7: // Image url
				switch ($this->level)
				{
				  case 2: // Image
					$this->image["url"] .= $cdata;
					break;
				}
			  break;
		  }
		}
	}
	
	function _handle_close_element(&$p, &$element) 
	{
		// Closing elements for all versions.
		// Because the elements can appear in orders differing from each other
		// the output is now created at the close of each of the critical elements.
		$element = strtolower($element);
		static $cnt;
		switch ($element)
		{
		  case 'channel':  // major elements -- define closing event
			// put channel information on the top. This should work even if the channel close element
			// occurs before the item tags
			// Avaible Image items
//			$this->image["link"] 	//a url to link to use orignal channel
//			$this->image["url"]		//src url for a img tag
//			$this->image["title"]   //for the Alt in a img tag
			// Avaible Channel items
//			$this->channel["link"]	//a url to link to the orignal channel
//			$this->channel["title"]	//The Title
//			$this->channel["desc"]	//A Small Description
			$this->channel["link"] = "";
			$this->channel["title"] = "";
			$this->channel["desc"] = "";
			$this->channelclosed = true;
			break;
		  case 'image': // Image tags closed
			// A little tricky here as image is often part of the channel container tags
			// Some feeds close the channel element and then provide the image.
			// Image has its own close element, unless the values are provided by Attributes!
			// Avaible Image items
//			$this->image["link"] 	//a url to link to use orignal channel
//			$this->image["url"]		//src url for a img tag
//			$this->image["title"]   //for the Alt in a img tag
			break;
		  case 'item':
			// Each item has its own close element
			if(!in_array($this->item['title'],$this->arss))
			{
//				Avaible Item Unit
//				$this->item["link"]		//A Link to orignal Item;
//				$this->item["title"]	//The Title;
//				$$this->item["desc"]	//A Small Description;
				$this->item['desc'] .= '<br><br>[URL=' . $this->item["link"] . ']'.$this->item["title"].'[/URL]';
				$this->prase();
				$this->counter++;
			}
			$this->item["link"] = "";
			$this->item["title"] = "";
			$this->item["desc"] = "";
			break;
		  default: // ignore all other close elements
			break;
		}
	}
	
	//**************************************************************
	// RSS to Topic Praser
	//**************************************************************	
	function prase() {
		global $ibforums, $forums, $DB, $std, $print, $skin_universal;
        require_once( ROOT_PATH."sources/lib/post_parser.php" );
        $parser = new post_parser(1);
		
		$post = array(
					'author_id'   => 0, //$ibforums->member['id'] ? $ibforums->member['id'] : 0,
					'use_sig'     => 1,
					'use_emo'     => 1,
					'ip_address'  => "0.0.0.0",
					'post_date'   => time(),
					'icon_id'     => 0,
					'post'        => $parser->convert( array( TEXT    => $this->item['desc'],
																	SMILIES => 0,
																	CODE    => 1,
																	HTML    => 0
																  )
														   ),
					'author_name' => "RSS Bot",//$ibforums->member['id'] ? $ibforums->member['name'] : $ibforums->input['UserName'],
					'topic_id'    => "",
					'queued'      => 0,//( $this->obj['moderate'] == 1 || $this->obj['moderate'] == 3 ) ? 1 : 0,
					'post_htmlstate' => 0,//intval($ibforums->input['post_htmlstatus']),
				 );
				 
		$topic = array(
							  'title'            => $this->item['title'],
							  'description'      => '',
							  'state'            => 'open',//$state
							  'posts'            => 0,
							  'starter_id'       => $post['author_id'],//$ibforums->member['id'],
							  'starter_name'     => $post['author_name'],//$ibforums->member['id'] ?  $ibforums->member['name'] : $ibforums->input['UserName'],
							  'start_date'       => time(),
							  'last_poster_id'   => $post['author_id'],//$ibforums->member['id'],
							  'last_poster_name' => $post['author_name'],//$ibforums->member['id'] ?  $ibforums->member['name'] : $ibforums->input['UserName'],
							  'last_post'        => time(),
							  'icon_id'          => 0,//$ibforums->input['iconid'],
							  'author_mode'      => 0,//$ibforums->member['id'] ? 1 : 0,
							  'poll_state'       => 0,
							  'last_vote'        => 0,
							  'views'            => 0,
							  'forum_id'         => $this->fid,
							  'approved'         => 1,//( $this->class->obj['moderate'] == 1 || $this->class->obj['moderate'] == 2 ) ? 0 : 1,
							  'pinned'           => 0,//$pinned,
							 );
							 
		$DB->do_insert( 'topics', $topic );
		
		$post['topic_id']  = $DB->get_insert_id();
		$topic['tid']      = $post['topic_id'];
		//-------------------------------------------------
		// Update the post info with the upload array info
		//-------------------------------------------------
		$post['post_key']  = md5(microtime());
		$post['new_topic'] = 1;
		//-------------------------------------------------
		// Unqueue the post if we're starting a new topic
		//-------------------------------------------------
		$post['queued'] = 0;
		//-------------------------------------------------
		// Add post to DB
		//-------------------------------------------------
		$DB->do_insert( 'posts', $post );
		$post['pid'] = $DB->get_insert_id();
		//-------------------------------------------------
		// Update topic with firstpost ID
		//-------------------------------------------------
		
		$DB->simple_construct( array( 'update' => 'topics',
									  'set'    => "topic_firstpost=".$post['pid'],
									  'where'  => "tid=".$topic['tid']
							 )      );
							 
		$DB->simple_exec();	
		
		$dbs = array();
		if($this->lastpostfix == 1)
		{
			$dbs = array( 'last_title'       => $topic['title'],
					  'last_id'          => $topic['tid'],
					  'last_post'        => time(),
					  'last_poster_name' => $post['author_name'],//$ibforums->member['id'] ?  $ibforums->member['name'] : $ibforums->input['UserName'],
					  'last_poster_id'   => $post['author_id']//$ibforums->member['id'],
			);
		}

		$dbs['topics']         = ++$this->tcnt;		
		$DB->do_update( 'forums', $dbs, "id=".intval($this->fid) );
		
		//----------------------------------------
		// Update forum cache
		//----------------------------------------
		
		$ibforums->cache['forum_cache'] = array();
			
		$DB->simple_construct( array( 'select' => '*',
									  'from'   => 'forums',
									  'order'  => 'parent_id, position'
							 )      );
		$DB->simple_exec();
		
		while( $fr = $DB->fetch_row() )
		{
			$perms = unserialize(stripslashes($fr['permission_array']));
			
			$fr['read_perms']   = $perms['read_perms'];
			$fr['reply_perms']  = $perms['reply_perms'];
			$fr['start_perms']  = $perms['start_perms'];
			$fr['upload_perms'] = $perms['upload_perms'];
			$fr['show_perms']   = $perms['show_perms'];
			
			unset($fr['permission_array']);
			
			$ibforums->cache['forum_cache'][ $fr['id'] ] = $fr;
		}
		
		$std->update_cache( array( 'name' => 'forum_cache', 'array' => 1, 'deletefirst' => 0, 'donow' => 1 ) );
		$std->update_cache( array( 'name' => 'stats'      , 'array' => 1, 'deletefirst' => 0, 'donow' => 1 ) );		
	}
}
?>